/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import com.sun.j3d.internal.BufferWrapper;
import com.sun.j3d.internal.ByteBufferWrapper;
import com.sun.j3d.internal.DoubleBufferWrapper;
import com.sun.j3d.internal.FloatBufferWrapper;
import com.sun.j3d.utils.compression.CommandStream;
import com.sun.j3d.utils.compression.CompressionStreamColor;
import com.sun.j3d.utils.compression.CompressionStreamElement;
import com.sun.j3d.utils.compression.CompressionStreamNormal;
import com.sun.j3d.utils.compression.CompressionStreamVertex;
import com.sun.j3d.utils.compression.HuffmanTable;
import com.sun.j3d.utils.compression.MeshBuffer;
import com.sun.j3d.utils.geometry.GeometryInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;

public class CompressionStream {
    private static final boolean debug = false;
    private static final boolean benchmark = false;
    private static final boolean noMeshNormalSubstitution = true;
    static final int RESTART = 1;
    static final int REPLACE_MIDDLE = 2;
    static final int REPLACE_OLDEST = 3;
    static final int MESH_PUSH = 1;
    static final int NO_MESH_PUSH = 0;
    static final float ByteToFloatScale = 0.003921569f;
    int streamType;
    int vertexComponents;
    boolean vertexColors;
    boolean vertexColor3;
    boolean vertexColor4;
    boolean vertexNormals;
    boolean vertexTextures;
    boolean vertexTexture2;
    boolean vertexTexture3;
    boolean vertexTexture4;
    Point3d[] mcBounds = new Point3d[2];
    Point3d[] ncBounds = new Point3d[2];
    Point3i[] qcBounds = new Point3i[2];
    double[] center = new double[3];
    double positionRangeMaximum;
    double scale;
    int positionQuant;
    int colorQuant;
    int normalQuant;
    boolean positionQuantChanged;
    boolean colorQuantChanged;
    boolean normalQuantChanged;
    int[] lastPosition = new int[3];
    int[] lastColor = new int[4];
    int lastSextant;
    int lastOctant;
    int lastU;
    int lastV;
    boolean lastSpecialNormal;
    boolean firstPosition;
    boolean firstColor;
    boolean firstNormal;
    int byteCount = 0;
    int vertexCount = 0;
    int meshReferenceCount = 0;
    MeshBuffer meshBuffer = new MeshBuffer();
    private Collection stream;
    private boolean lastElementColor = false;
    private boolean lastLastElementColor = false;
    private boolean lastElementNormal = false;
    private boolean lastLastElementNormal = false;
    private Point3f p3f = new Point3f();
    private Color3f c3f = new Color3f();
    private Color4f c4f = new Color4f();
    private Vector3f n3f = new Vector3f();

    private CompressionStream() {
        this.stream = new LinkedList();
        this.mcBounds[0] = new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.mcBounds[1] = new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.qcBounds[0] = new Point3i(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.qcBounds[1] = new Point3i(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.ncBounds[0] = new Point3d();
        this.ncBounds[1] = new Point3d();
    }

    CompressionStream(int n2, int n3) {
        this();
        this.streamType = n2;
        this.vertexComponents = this.getVertexComponents(n3);
    }

    private int getVertexComponents(int n2) {
        int n3 = 0;
        this.vertexTexture4 = false;
        this.vertexTexture3 = false;
        this.vertexTexture2 = false;
        this.vertexTextures = false;
        this.vertexNormals = false;
        this.vertexColor4 = false;
        this.vertexColor3 = false;
        this.vertexColors = false;
        if ((n2 & 2) != 0) {
            this.vertexNormals = true;
            n3 &= 2;
        }
        if ((n2 & 4) != 0) {
            this.vertexColors = true;
            if ((n2 & 0xC) != 0) {
                this.vertexColor4 = true;
                n3 &= 0xC;
            } else {
                this.vertexColor3 = true;
                n3 &= 4;
            }
        }
        if ((n2 & 0x20) != 0) {
            this.vertexTextures = true;
            this.vertexTexture2 = true;
            n3 &= 0x20;
        } else if ((n2 & 0x40) != 0) {
            this.vertexTextures = true;
            this.vertexTexture3 = true;
            n3 &= 0x40;
        } else if ((n2 & 0x400) != 0) {
            this.vertexTextures = true;
            this.vertexTexture4 = true;
            n3 &= 0x400;
        }
        if (this.vertexTextures) {
            throw new UnsupportedOperationException("\ncompression of texture coordinates is not supported");
        }
        return n3;
    }

    private int getStreamType(GeometryArray geometryArray) {
        if (geometryArray instanceof TriangleStripArray || geometryArray instanceof IndexedTriangleStripArray || geometryArray instanceof TriangleFanArray || geometryArray instanceof IndexedTriangleFanArray || geometryArray instanceof TriangleArray || geometryArray instanceof IndexedTriangleArray || geometryArray instanceof QuadArray || geometryArray instanceof IndexedQuadArray) {
            return 2;
        }
        if (geometryArray instanceof LineArray || geometryArray instanceof IndexedLineArray || geometryArray instanceof LineStripArray || geometryArray instanceof IndexedLineStripArray) {
            return 1;
        }
        return 0;
    }

    void quantize(HuffmanTable huffmanTable) {
        this.positionQuant = 16;
        this.colorQuant = 9;
        this.normalQuant = 6;
        this.center[0] = (this.mcBounds[1].x + this.mcBounds[0].x) / 2.0;
        this.center[1] = (this.mcBounds[1].y + this.mcBounds[0].y) / 2.0;
        this.center[2] = (this.mcBounds[1].z + this.mcBounds[0].z) / 2.0;
        double d2 = this.mcBounds[1].x - this.mcBounds[0].x;
        double d3 = this.mcBounds[1].y - this.mcBounds[0].y;
        double d4 = this.mcBounds[1].z - this.mcBounds[0].z;
        this.positionRangeMaximum = d2 > d3 ? d2 : d3;
        if (d4 > this.positionRangeMaximum) {
            this.positionRangeMaximum = d4;
        }
        this.scale = 2.0 / this.positionRangeMaximum * 0.999969482421875;
        this.normalQuantChanged = true;
        this.colorQuantChanged = true;
        this.positionQuantChanged = true;
        this.firstNormal = true;
        this.firstColor = true;
        this.firstPosition = true;
        for (Object e2 : this.stream) {
            if (!(e2 instanceof CompressionStreamElement)) continue;
            ((CompressionStreamElement)e2).quantize(this, huffmanTable);
            this.lastLastElementColor = this.lastElementColor;
            this.lastLastElementNormal = this.lastElementNormal;
            this.lastElementNormal = false;
            this.lastElementColor = false;
            if (e2 instanceof CompressionStreamColor) {
                this.lastElementColor = true;
                continue;
            }
            if (!(e2 instanceof CompressionStreamNormal)) continue;
            this.lastElementNormal = true;
        }
        this.ncBounds[0].x = (double)this.qcBounds[0].x / 32768.0;
        this.ncBounds[0].y = (double)this.qcBounds[0].y / 32768.0;
        this.ncBounds[0].z = (double)this.qcBounds[0].z / 32768.0;
        this.ncBounds[1].x = (double)this.qcBounds[1].x / 32768.0;
        this.ncBounds[1].y = (double)this.qcBounds[1].y / 32768.0;
        this.ncBounds[1].z = (double)this.qcBounds[1].z / 32768.0;
    }

    void outputCommands(HuffmanTable huffmanTable, CommandStream commandStream) {
        int n2 = this.vertexNormals ? 1 : 0;
        int n3 = this.vertexColor3 || this.vertexColor4 ? 1 : 0;
        int n4 = this.vertexColor4 ? 1 : 0;
        int n5 = 0x18 | n2;
        long l2 = n3 << 2 | n4 << 1;
        commandStream.addCommand(n5, 8, l2, 3);
        huffmanTable.outputCommands(commandStream);
        for (Object e2 : this.stream) {
            if (!(e2 instanceof CompressionStreamElement)) continue;
            ((CompressionStreamElement)e2).outputCommand(huffmanTable, commandStream);
        }
        commandStream.end();
    }

    int getByteCount() {
        return this.byteCount;
    }

    int getVertexCount() {
        return this.vertexCount;
    }

    int getMeshReferenceCount() {
        return this.meshReferenceCount;
    }

    void addVertex(Point3f point3f, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, (Color3f)null, n2, 0));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, (Color3f)null, n2, 0));
    }

    void addVertex(Point3f point3f, Color3f color3f, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, color3f, n2, 0));
    }

    void addVertex(Point3f point3f, Color4f color4f, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, color4f, n2, 0));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Color3f color3f, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, color3f, n2, 0));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Color4f color4f, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, color4f, n2, 0));
    }

    void addVertex(Point3f point3f, int n2, int n3) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, (Color3f)null, n2, n3));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, int n2, int n3) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, (Color3f)null, n2, n3));
    }

    void addVertex(Point3f point3f, Color3f color3f, int n2, int n3) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, color3f, n2, n3));
    }

    void addVertex(Point3f point3f, Color4f color4f, int n2, int n3) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, color4f, n2, n3));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Color3f color3f, int n2, int n3) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, color3f, n2, n3));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Color4f color4f, int n2, int n3) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, color4f, n2, n3));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Object object, int n2, int n3) {
        if (this.vertexColor3) {
            this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, (Color3f)object, n2, n3));
        } else {
            this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, (Color4f)object, n2, n3));
        }
    }

    void addMeshReference(int n2, int n3) {
        this.stream.add(new MeshReference(n2, n3));
    }

    void addColor(Color3f color3f) {
        this.stream.add(new CompressionStreamColor(this, color3f));
    }

    void addColor(Color4f color4f) {
        this.stream.add(new CompressionStreamColor(this, color4f));
    }

    void addNormal(Vector3f vector3f) {
        this.stream.add(new CompressionStreamNormal(this, vector3f));
    }

    void addPositionQuantization(int n2) {
        this.stream.add(new PositionQuant(n2));
    }

    void addColorQuantization(int n2) {
        this.stream.add(new ColorQuant(n2));
    }

    void addNormalQuantization(int n2) {
        this.stream.add(new NormalQuant(n2));
    }

    private void getIndexArrays(GeometryArray geometryArray, IndexArrays indexArrays) {
        IndexedGeometryArray indexedGeometryArray = (IndexedGeometryArray)geometryArray;
        int n2 = indexedGeometryArray.getInitialIndexIndex();
        int n3 = indexedGeometryArray.getValidIndexCount();
        int n4 = indexedGeometryArray.getVertexFormat();
        boolean bl = false;
        if ((n4 & 0x200) != 0) {
            bl = true;
        }
        indexArrays.positionIndices = new int[n3];
        indexedGeometryArray.getCoordinateIndices(n2, indexArrays.positionIndices);
        if (this.vertexNormals) {
            if (bl) {
                indexArrays.normalIndices = indexArrays.positionIndices;
            } else {
                indexArrays.normalIndices = new int[n3];
                indexedGeometryArray.getNormalIndices(n2, indexArrays.normalIndices);
            }
        }
        if (this.vertexColor3 || this.vertexColor4) {
            if (bl) {
                indexArrays.colorIndices = indexArrays.positionIndices;
            } else {
                indexArrays.colorIndices = new int[n3];
                indexedGeometryArray.getColorIndices(n2, indexArrays.colorIndices);
            }
        }
    }

    private void getVertexIndices(int n2, IndexArrays indexArrays, VertexIndices vertexIndices) {
        vertexIndices.pi = indexArrays.positionIndices[n2];
        if (this.vertexNormals) {
            vertexIndices.ni = indexArrays.normalIndices[n2];
        }
        if (this.vertexColors) {
            vertexIndices.ci = indexArrays.colorIndices[n2];
        }
    }

    private void processVertexCopy(VertexCopy vertexCopy, int n2) {
        int n3 = this.meshBuffer.getMeshReference(vertexCopy.p);
        if (n3 == -1 || this.vertexNormals && !vertexCopy.n.equals(this.meshBuffer.getNormal(n3))) {
            this.addVertex(vertexCopy.p, vertexCopy.n, vertexCopy.c, n2, 1);
            this.meshBuffer.push(vertexCopy.p, vertexCopy.c, vertexCopy.n);
        } else {
            if (this.vertexNormals) {
                // empty if block
            }
            if (this.vertexColor3 && !vertexCopy.c3.equals(this.meshBuffer.getColor3(n3))) {
                this.addColor(vertexCopy.c3);
            } else if (this.vertexColor4 && !vertexCopy.c4.equals(this.meshBuffer.getColor4(n3))) {
                this.addColor(vertexCopy.c4);
            }
            this.addMeshReference(n2, n3);
        }
    }

    private void processIndexedVertexCopy(VertexCopy vertexCopy, VertexIndices vertexIndices, int n2) {
        int n3 = this.meshBuffer.getMeshReference(vertexIndices.pi);
        if (n3 == -1 || this.vertexNormals && vertexIndices.ni != this.meshBuffer.getNormalIndex(n3)) {
            this.addVertex(vertexCopy.p, vertexCopy.n, vertexCopy.c, n2, 1);
            this.meshBuffer.push(vertexIndices.pi, vertexIndices.ci, vertexIndices.ni);
        } else {
            if (this.vertexNormals) {
                // empty if block
            }
            if (this.vertexColor3 && vertexIndices.ci != this.meshBuffer.getColorIndex(n3)) {
                this.addColor(vertexCopy.c3);
            } else if (this.vertexColor4 && vertexIndices.ci != this.meshBuffer.getColorIndex(n3)) {
                this.addColor(vertexCopy.c4);
            }
            this.addMeshReference(n2, n3);
        }
    }

    void addGeometryArray(GeometryArray geometryArray) {
        int n2 = 0;
        int n3 = 0;
        int n4 = geometryArray.getVertexFormat();
        GeometryAccessor geometryAccessor = null;
        if (this.streamType != this.getStreamType(geometryArray)) {
            throw new IllegalArgumentException("GeometryArray has inconsistent dimensionality");
        }
        if (this.vertexComponents != this.getVertexComponents(n4)) {
            throw new IllegalArgumentException("GeometryArray has inconsistent vertex components");
        }
        boolean bl = (n4 & 0x800) != 0;
        boolean bl2 = (n4 & 0x80) != 0;
        boolean bl3 = (n4 & 0x100) != 0;
        boolean bl4 = geometryArray instanceof IndexedGeometryArray;
        if (bl4) {
            n2 = 0;
            n3 = ((IndexedGeometryArray)geometryArray).getValidIndexCount();
        }
        if (!bl2) {
            if (bl4) {
                geometryAccessor = new IndexedByCopyGeometry(geometryArray);
            } else {
                n2 = 0;
                n3 = geometryArray.getValidVertexCount();
                geometryAccessor = new ByCopyGeometry(geometryArray);
            }
        } else if (bl3 && bl) {
            if (bl4) {
                geometryAccessor = new IndexedInterleavedGeometryNIO(geometryArray);
            } else {
                n2 = geometryArray.getInitialVertexIndex();
                n3 = geometryArray.getValidVertexCount();
                geometryAccessor = new InterleavedGeometryNIO(geometryArray);
            }
        } else if (bl3 && !bl) {
            if (bl4) {
                geometryAccessor = new IndexedInterleavedGeometryFloat(geometryArray);
            } else {
                n2 = geometryArray.getInitialVertexIndex();
                n3 = geometryArray.getValidVertexCount();
                geometryAccessor = new InterleavedGeometryFloat(geometryArray);
            }
        } else if (!bl3 && bl) {
            if (bl4) {
                geometryAccessor = new IndexedByRefGeometryNIO(geometryArray);
            } else {
                n2 = 0;
                n3 = geometryArray.getValidVertexCount();
                geometryAccessor = new ByRefGeometryNIO(geometryArray);
            }
        } else if (!bl3 && !bl) {
            if (bl4) {
                geometryAccessor = new IndexedByRefGeometry(geometryArray);
            } else {
                n2 = 0;
                n3 = geometryArray.getValidVertexCount();
                geometryAccessor = new ByRefGeometry(geometryArray);
            }
        }
        int n5 = 0;
        int[] nArray = null;
        int n6 = 0;
        int n7 = 1;
        boolean bl5 = false;
        boolean bl6 = false;
        if (geometryArray instanceof TriangleStripArray || geometryArray instanceof IndexedTriangleStripArray || geometryArray instanceof LineStripArray || geometryArray instanceof IndexedLineStripArray) {
            bl5 = true;
            n7 = 3;
        } else if (geometryArray instanceof TriangleFanArray || geometryArray instanceof IndexedTriangleFanArray) {
            bl5 = true;
            n7 = 2;
        } else if (geometryArray instanceof QuadArray || geometryArray instanceof IndexedQuadArray) {
            bl6 = true;
            n6 = 4;
            n7 = 2;
        }
        if (bl5) {
            GeometryArray geometryArray2;
            if (bl4) {
                geometryArray2 = (IndexedGeometryStripArray)geometryArray;
                n5 = ((IndexedGeometryStripArray)geometryArray2).getNumStrips();
                nArray = new int[n5];
                ((IndexedGeometryStripArray)geometryArray2).getStripIndexCounts(nArray);
            } else {
                geometryArray2 = (GeometryStripArray)geometryArray;
                n5 = ((GeometryStripArray)geometryArray2).getNumStrips();
                nArray = new int[n5];
                ((GeometryStripArray)geometryArray2).getStripVertexCounts(nArray);
            }
        }
        int n8 = n2;
        if (bl5) {
            for (int i2 = 0; i2 < n5; ++i2) {
                geometryAccessor.processVertex(n8++, 1);
                for (int i3 = 1; i3 < nArray[i2]; ++i3) {
                    geometryAccessor.processVertex(n8++, n7);
                }
            }
        } else if (bl6) {
            while (n8 < n2 + n3) {
                geometryAccessor.processVertex(n8++, 1);
                for (int i4 = 1; i4 < n6; ++i4) {
                    geometryAccessor.processVertex(n8++, n7);
                }
            }
        } else {
            while (n8 < n2 + n3) {
                geometryAccessor.processVertex(n8++, 1);
            }
        }
    }

    void print() {
        System.out.println("\nstream has " + this.stream.size() + " entries");
        System.out.println("uncompressed size " + this.byteCount + " bytes");
        System.out.println("upper position bound: " + this.mcBounds[1].toString());
        System.out.println("lower position bound: " + this.mcBounds[0].toString());
        System.out.println("X, Y, Z centers (" + (float)this.center[0] + " " + (float)this.center[1] + " " + (float)this.center[2] + ")\n" + "scale " + (float)this.scale + "\n");
        Iterator iterator = this.stream.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next().toString() + "\n");
        }
    }

    public CompressionStream(int n2, int n3, int n4, Shape3D[] shape3DArray) {
        this();
        if (shape3DArray == null) {
            throw new IllegalArgumentException("null Shape3D array");
        }
        if (shape3DArray.length == 0) {
            throw new IllegalArgumentException("zero-length Shape3D array");
        }
        if (shape3DArray[0] == null) {
            throw new IllegalArgumentException("Shape3D at index 0 is null");
        }
        long l2 = 0L;
        Geometry geometry = shape3DArray[0].getGeometry();
        if (!(geometry instanceof GeometryArray)) {
            throw new IllegalArgumentException("Shape3D at index 0 is not a GeometryArray");
        }
        GeometryArray geometryArray = (GeometryArray)geometry;
        this.streamType = this.getStreamType(geometryArray);
        this.vertexComponents = this.getVertexComponents(geometryArray.getVertexFormat());
        this.addPositionQuantization(n2);
        this.addColorQuantization(n3);
        this.addNormalQuantization(n4);
        for (int i2 = 0; i2 < shape3DArray.length; ++i2) {
            Material material;
            geometry = shape3DArray[i2].getGeometry();
            if (!(geometry instanceof GeometryArray)) {
                throw new IllegalArgumentException("Shape3D at index " + i2 + " is not a GeometryArray");
            }
            Appearance appearance = shape3DArray[i2].getAppearance();
            if (appearance != null && (material = appearance.getMaterial()) != null) {
                material.getDiffuseColor(this.c3f);
                if (this.vertexColor4) {
                    this.c4f.set(this.c3f.x, this.c3f.y, this.c3f.z, 1.0f);
                    this.addColor(this.c4f);
                } else {
                    this.addColor(this.c3f);
                }
            }
            this.addGeometryArray((GeometryArray)geometry);
        }
    }

    public CompressionStream(Shape3D[] shape3DArray) {
        this(16, 9, 6, shape3DArray);
    }

    public CompressionStream(int n2, int n3, int n4, GeometryInfo[] geometryInfoArray) {
        this();
        if (geometryInfoArray == null) {
            throw new IllegalArgumentException("null GeometryInfo array");
        }
        if (geometryInfoArray.length == 0) {
            throw new IllegalArgumentException("zero-length GeometryInfo array");
        }
        if (geometryInfoArray[0] == null) {
            throw new IllegalArgumentException("GeometryInfo at index 0 is null");
        }
        long l2 = 0L;
        GeometryArray geometryArray = geometryInfoArray[0].getGeometryArray();
        this.streamType = this.getStreamType(geometryArray);
        this.vertexComponents = this.getVertexComponents(geometryArray.getVertexFormat());
        this.addPositionQuantization(n2);
        this.addColorQuantization(n3);
        this.addNormalQuantization(n4);
        for (int i2 = 0; i2 < geometryInfoArray.length; ++i2) {
            this.addGeometryArray(geometryInfoArray[i2].getGeometryArray());
        }
    }

    public CompressionStream(GeometryInfo[] geometryInfoArray) {
        this(16, 9, 6, geometryInfoArray);
    }

    public Point3d[] getModelBounds() {
        Point3d[] point3dArray = new Point3d[]{new Point3d(this.mcBounds[0]), new Point3d(this.mcBounds[1])};
        return point3dArray;
    }

    public Point3d[] getNormalizedBounds() {
        Point3d[] point3dArray = new Point3d[]{new Point3d(this.ncBounds[0]), new Point3d(this.ncBounds[1])};
        return point3dArray;
    }

    private class ByCopyGeometry
    implements GeometryAccessor {
        Point3f[] positions = null;
        Vector3f[] normals = null;
        Color3f[] colors3 = null;
        Color4f[] colors4 = null;

        ByCopyGeometry(GeometryArray geometryArray) {
            this(geometryArray, geometryArray.getInitialVertexIndex(), geometryArray.getValidVertexCount());
        }

        ByCopyGeometry(GeometryArray geometryArray, int n2, int n3) {
            int n4;
            this.positions = new Point3f[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                this.positions[n4] = new Point3f();
            }
            geometryArray.getCoordinates(n2, this.positions);
            if (CompressionStream.this.vertexNormals) {
                this.normals = new Vector3f[n3];
                for (n4 = 0; n4 < n3; ++n4) {
                    this.normals[n4] = new Vector3f();
                }
                geometryArray.getNormals(n2, this.normals);
            }
            if (CompressionStream.this.vertexColor3) {
                this.colors3 = new Color3f[n3];
                for (n4 = 0; n4 < n3; ++n4) {
                    this.colors3[n4] = new Color3f();
                }
                geometryArray.getColors(n2, this.colors3);
            } else if (CompressionStream.this.vertexColor4) {
                this.colors4 = new Color4f[n3];
                for (n4 = 0; n4 < n3; ++n4) {
                    this.colors4[n4] = new Color4f();
                }
                geometryArray.getColors(n2, this.colors4);
            }
        }

        public void processVertex(int n2, int n3) {
            Point3f point3f = this.positions[n2];
            int n4 = CompressionStream.this.meshBuffer.getMeshReference(point3f);
            MeshBuffer cfr_ignored_0 = CompressionStream.this.meshBuffer;
            if (n4 == -1 || CompressionStream.this.vertexNormals && !this.normals[n2].equals(CompressionStream.this.meshBuffer.getNormal(n4))) {
                Vector3f vector3f;
                Vector3f vector3f2 = vector3f = CompressionStream.this.vertexNormals ? this.normals[n2] : null;
                Color3f color3f = CompressionStream.this.vertexColor3 ? this.colors3[n2] : (CompressionStream.this.vertexColor4 ? this.colors4[n2] : null);
                CompressionStream.this.addVertex(point3f, vector3f, (Object)color3f, n3, 1);
                CompressionStream.this.meshBuffer.push(point3f, (Object)color3f, vector3f);
            } else {
                if (CompressionStream.this.vertexNormals) {
                    // empty if block
                }
                if (CompressionStream.this.vertexColor3 && !this.colors3[n2].equals(CompressionStream.this.meshBuffer.getColor3(n4))) {
                    CompressionStream.this.addColor(this.colors3[n2]);
                } else if (CompressionStream.this.vertexColor4 && !this.colors4[n2].equals(CompressionStream.this.meshBuffer.getColor4(n4))) {
                    CompressionStream.this.addColor(this.colors4[n2]);
                }
                CompressionStream.this.addMeshReference(n3, n4);
            }
        }
    }

    private class ByRefGeometry
    implements GeometryAccessor {
        VertexCopy vc = new VertexCopy();
        byte[] colorsB = null;
        float[] colorsF = null;
        float[] normals = null;
        float[] positionsF = null;
        double[] positionsD = null;
        int initialPositionIndex = 0;
        int initialNormalIndex = 0;
        int initialColorIndex = 0;

        ByRefGeometry(GeometryArray geometryArray) {
            this.positionsF = geometryArray.getCoordRefFloat();
            this.positionsD = geometryArray.getCoordRefDouble();
            if (this.positionsF == null && this.positionsD == null) {
                throw new UnsupportedOperationException("\nby-reference access to Point3{d,f} arrays");
            }
            this.initialPositionIndex = geometryArray.getInitialCoordIndex();
            if (CompressionStream.this.vertexColors) {
                this.colorsB = geometryArray.getColorRefByte();
                this.colorsF = geometryArray.getColorRefFloat();
                if (this.colorsB == null && this.colorsF == null) {
                    throw new UnsupportedOperationException("\nby-reference access to Color{3b,3f,4b,4f} arrays");
                }
                this.initialColorIndex = geometryArray.getInitialColorIndex();
            }
            if (CompressionStream.this.vertexNormals) {
                this.normals = geometryArray.getNormalRefFloat();
                if (this.normals == null) {
                    throw new UnsupportedOperationException("\nby-reference access to Normal3f array");
                }
                this.initialNormalIndex = geometryArray.getInitialNormalIndex();
            }
        }

        void copyVertex(int n2, int n3, int n4, VertexCopy vertexCopy) {
            vertexCopy.p = this.positionsF != null ? new Point3f(this.positionsF[n2 + 0], this.positionsF[n2 + 1], this.positionsF[n2 + 2]) : new Point3f((float)this.positionsD[(n2 *= 3) + 0], (float)this.positionsD[n2 + 1], (float)this.positionsD[n2 + 2]);
            n3 *= 3;
            if (CompressionStream.this.vertexNormals) {
                vertexCopy.n = new Vector3f(this.normals[n3 + 0], this.normals[n3 + 1], this.normals[n3 + 2]);
            }
            if (CompressionStream.this.vertexColor3) {
                vertexCopy.c3 = this.colorsB != null ? new Color3f((float)(this.colorsB[n4 + 0] & 0xFF) * 0.003921569f, (float)(this.colorsB[n4 + 1] & 0xFF) * 0.003921569f, (float)(this.colorsB[n4 + 2] & 0xFF) * 0.003921569f) : new Color3f(this.colorsF[(n4 *= 3) + 0], this.colorsF[n4 + 1], this.colorsF[n4 + 2]);
                vertexCopy.c = vertexCopy.c3;
            } else if (CompressionStream.this.vertexColor4) {
                vertexCopy.c4 = this.colorsB != null ? new Color4f((float)(this.colorsB[n4 + 0] & 0xFF) * 0.003921569f, (float)(this.colorsB[n4 + 1] & 0xFF) * 0.003921569f, (float)(this.colorsB[n4 + 2] & 0xFF) * 0.003921569f, (float)(this.colorsB[n4 + 3] & 0xFF) * 0.003921569f) : new Color4f(this.colorsF[(n4 *= 4) + 0], this.colorsF[n4 + 1], this.colorsF[n4 + 2], this.colorsF[n4 + 3]);
                vertexCopy.c = vertexCopy.c4;
            }
        }

        public void processVertex(int n2, int n3) {
            this.copyVertex(n2 + this.initialPositionIndex, n2 + this.initialNormalIndex, n2 + this.initialColorIndex, this.vc);
            CompressionStream.this.processVertexCopy(this.vc, n3);
        }
    }

    private class ByRefGeometryNIO
    implements GeometryAccessor {
        VertexCopy vc = new VertexCopy();
        ByteBufferWrapper colorsB = null;
        FloatBufferWrapper colorsF = null;
        FloatBufferWrapper normals = null;
        FloatBufferWrapper positionsF = null;
        DoubleBufferWrapper positionsD = null;
        int initialPositionIndex = 0;
        int initialNormalIndex = 0;
        int initialColorIndex = 0;

        ByRefGeometryNIO(GeometryArray geometryArray) {
            J3DBuffer j3DBuffer = geometryArray.getCoordRefBuffer();
            this.initialPositionIndex = geometryArray.getInitialCoordIndex();
            switch (BufferWrapper.getBufferType(j3DBuffer)) {
                case 3: {
                    this.positionsF = new FloatBufferWrapper(j3DBuffer);
                    break;
                }
                case 4: {
                    this.positionsD = new DoubleBufferWrapper(j3DBuffer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\nposition buffer must be FloatBuffer or DoubleBuffer");
                }
            }
            if (CompressionStream.this.vertexColors) {
                j3DBuffer = geometryArray.getColorRefBuffer();
                this.initialColorIndex = geometryArray.getInitialColorIndex();
                switch (BufferWrapper.getBufferType(j3DBuffer)) {
                    case 2: {
                        this.colorsB = new ByteBufferWrapper(j3DBuffer);
                        break;
                    }
                    case 3: {
                        this.colorsF = new FloatBufferWrapper(j3DBuffer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\ncolor buffer must be ByteBuffer or FloatBuffer");
                    }
                }
            }
            if (CompressionStream.this.vertexNormals) {
                j3DBuffer = geometryArray.getNormalRefBuffer();
                this.initialNormalIndex = geometryArray.getInitialNormalIndex();
                switch (BufferWrapper.getBufferType(j3DBuffer)) {
                    case 3: {
                        this.normals = new FloatBufferWrapper(j3DBuffer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\nnormal buffer must be FloatBuffer");
                    }
                }
            }
        }

        void copyVertex(int n2, int n3, int n4, VertexCopy vertexCopy) {
            vertexCopy.p = this.positionsF != null ? new Point3f(this.positionsF.get(n2 + 0), this.positionsF.get(n2 + 1), this.positionsF.get(n2 + 2)) : new Point3f((float)this.positionsD.get((n2 *= 3) + 0), (float)this.positionsD.get(n2 + 1), (float)this.positionsD.get(n2 + 2));
            n3 *= 3;
            if (CompressionStream.this.vertexNormals) {
                vertexCopy.n = new Vector3f(this.normals.get(n3 + 0), this.normals.get(n3 + 1), this.normals.get(n3 + 2));
            }
            if (CompressionStream.this.vertexColor3) {
                vertexCopy.c3 = this.colorsB != null ? new Color3f((float)(this.colorsB.get(n4 + 0) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(n4 + 1) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(n4 + 2) & 0xFF) * 0.003921569f) : new Color3f(this.colorsF.get((n4 *= 3) + 0), this.colorsF.get(n4 + 1), this.colorsF.get(n4 + 2));
                vertexCopy.c = vertexCopy.c3;
            } else if (CompressionStream.this.vertexColor4) {
                vertexCopy.c4 = this.colorsB != null ? new Color4f((float)(this.colorsB.get(n4 + 0) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(n4 + 1) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(n4 + 2) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(n4 + 3) & 0xFF) * 0.003921569f) : new Color4f(this.colorsF.get((n4 *= 4) + 0), this.colorsF.get(n4 + 1), this.colorsF.get(n4 + 2), this.colorsF.get(n4 + 3));
                vertexCopy.c = vertexCopy.c4;
            }
        }

        public void processVertex(int n2, int n3) {
            this.copyVertex(n2 + this.initialPositionIndex, n2 + this.initialNormalIndex, n2 + this.initialColorIndex, this.vc);
            CompressionStream.this.processVertexCopy(this.vc, n3);
        }
    }

    private class ColorQuant
    extends CompressionStreamElement {
        int value;

        ColorQuant(int n2) {
            this.value = n2;
        }

        void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
            CompressionStream.this.colorQuant = this.value;
            CompressionStream.this.colorQuantChanged = true;
        }

        public String toString() {
            return "colorQuant: " + this.value;
        }
    }

    private static interface GeometryAccessor {
        public void processVertex(int var1, int var2);
    }

    private static class IndexArrays {
        int[] colorIndices = null;
        int[] normalIndices = null;
        int[] positionIndices = null;

        private IndexArrays() {
        }
    }

    private class IndexedByCopyGeometry
    extends ByCopyGeometry {
        IndexArrays ia;
        VertexIndices vi;

        IndexedByCopyGeometry(GeometryArray geometryArray) {
            super(geometryArray, 0, geometryArray.getVertexCount());
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(geometryArray, this.ia);
        }

        public void processVertex(int n2, int n3) {
            CompressionStream.this.getVertexIndices(n2, this.ia, this.vi);
            int n4 = CompressionStream.this.meshBuffer.getMeshReference(this.vi.pi);
            MeshBuffer cfr_ignored_0 = CompressionStream.this.meshBuffer;
            if (n4 == -1 || CompressionStream.this.vertexNormals && this.vi.ni != CompressionStream.this.meshBuffer.getNormalIndex(n4)) {
                Vector3f vector3f;
                Point3f point3f = this.positions[this.vi.pi];
                Vector3f vector3f2 = vector3f = CompressionStream.this.vertexNormals ? this.normals[this.vi.ni] : null;
                Color3f color3f = CompressionStream.this.vertexColor3 ? this.colors3[this.vi.ci] : (CompressionStream.this.vertexColor4 ? this.colors4[this.vi.ci] : null);
                CompressionStream.this.addVertex(point3f, vector3f, (Object)color3f, n3, 1);
                CompressionStream.this.meshBuffer.push(this.vi.pi, this.vi.ci, this.vi.ni);
            } else {
                if (CompressionStream.this.vertexNormals) {
                    // empty if block
                }
                if (CompressionStream.this.vertexColor3 && this.vi.ci != CompressionStream.this.meshBuffer.getColorIndex(n4)) {
                    CompressionStream.this.addColor(this.colors3[this.vi.ci]);
                } else if (CompressionStream.this.vertexColor4 && this.vi.ci != CompressionStream.this.meshBuffer.getColorIndex(n4)) {
                    CompressionStream.this.addColor(this.colors4[this.vi.ci]);
                }
                CompressionStream.this.addMeshReference(n3, n4);
            }
        }
    }

    private class IndexedByRefGeometry
    extends ByRefGeometry {
        IndexArrays ia;
        VertexIndices vi;

        IndexedByRefGeometry(GeometryArray geometryArray) {
            super(geometryArray);
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(geometryArray, this.ia);
        }

        public void processVertex(int n2, int n3) {
            CompressionStream.this.getVertexIndices(n2, this.ia, this.vi);
            this.copyVertex(this.vi.pi, this.vi.ni, this.vi.ci, this.vc);
            CompressionStream.this.processIndexedVertexCopy(this.vc, this.vi, n3);
        }
    }

    private class IndexedByRefGeometryNIO
    extends ByRefGeometryNIO {
        IndexArrays ia;
        VertexIndices vi;

        IndexedByRefGeometryNIO(GeometryArray geometryArray) {
            super(geometryArray);
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(geometryArray, this.ia);
        }

        public void processVertex(int n2, int n3) {
            CompressionStream.this.getVertexIndices(n2, this.ia, this.vi);
            this.copyVertex(this.vi.pi, this.vi.ni, this.vi.ci, this.vc);
            CompressionStream.this.processIndexedVertexCopy(this.vc, this.vi, n3);
        }
    }

    private class IndexedInterleavedGeometryFloat
    extends InterleavedGeometryFloat {
        IndexArrays ia;
        VertexIndices vi;

        IndexedInterleavedGeometryFloat(GeometryArray geometryArray) {
            super(geometryArray);
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(geometryArray, this.ia);
        }

        public void processVertex(int n2, int n3) {
            CompressionStream.this.getVertexIndices(n2, this.ia, this.vi);
            this.copyVertex(this.vi.pi, this.vi.ni, this.vi.ci, this.vc);
            CompressionStream.this.processIndexedVertexCopy(this.vc, this.vi, n3);
        }
    }

    private class IndexedInterleavedGeometryNIO
    extends InterleavedGeometryNIO {
        IndexArrays ia;
        VertexIndices vi;

        IndexedInterleavedGeometryNIO(GeometryArray geometryArray) {
            super(geometryArray);
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(geometryArray, this.ia);
        }

        public void processVertex(int n2, int n3) {
            CompressionStream.this.getVertexIndices(n2, this.ia, this.vi);
            this.copyVertex(this.vi.pi, this.vi.ni, this.vi.ci, this.vc);
            CompressionStream.this.processIndexedVertexCopy(this.vc, this.vi, n3);
        }
    }

    private abstract class InterleavedGeometry
    implements GeometryAccessor {
        VertexCopy vc = new VertexCopy();
        int vstride = 0;
        int coffset = 0;
        int noffset = 0;
        int poffset = 0;
        int tstride = 0;
        int tcount = 0;

        InterleavedGeometry(GeometryArray geometryArray) {
            if (CompressionStream.this.vertexTextures) {
                if (CompressionStream.this.vertexTexture2) {
                    this.tstride = 2;
                } else if (CompressionStream.this.vertexTexture3) {
                    this.tstride = 3;
                } else if (CompressionStream.this.vertexTexture4) {
                    this.tstride = 4;
                }
                this.tcount = geometryArray.getTexCoordSetCount();
                this.vstride += this.tcount * this.tstride;
            }
            if (CompressionStream.this.vertexColors) {
                this.coffset = this.vstride;
                this.vstride = CompressionStream.this.vertexColor3 ? (this.vstride += 3) : (this.vstride += 4);
            }
            if (CompressionStream.this.vertexNormals) {
                this.noffset = this.vstride;
                this.vstride += 3;
            }
            this.poffset = this.vstride;
            this.vstride += 3;
        }

        abstract void copyVertex(int var1, int var2, int var3, VertexCopy var4);

        public void processVertex(int n2, int n3) {
            this.copyVertex(n2, n2, n2, this.vc);
            CompressionStream.this.processVertexCopy(this.vc, n3);
        }
    }

    private class InterleavedGeometryFloat
    extends InterleavedGeometry {
        float[] vdata;

        InterleavedGeometryFloat(GeometryArray geometryArray) {
            super(geometryArray);
            this.vdata = null;
            this.vdata = geometryArray.getInterleavedVertices();
        }

        void copyVertex(int n2, int n3, int n4, VertexCopy vertexCopy) {
            int n5 = n2 * this.vstride;
            vertexCopy.p = new Point3f(this.vdata[n5 + this.poffset + 0], this.vdata[n5 + this.poffset + 1], this.vdata[n5 + this.poffset + 2]);
            if (CompressionStream.this.vertexNormals) {
                n5 = n3 * this.vstride;
                vertexCopy.n = new Vector3f(this.vdata[n5 + this.noffset + 0], this.vdata[n5 + this.noffset + 1], this.vdata[n5 + this.noffset + 2]);
            }
            if (CompressionStream.this.vertexColor3) {
                n5 = n4 * this.vstride;
                vertexCopy.c3 = new Color3f(this.vdata[n5 + this.coffset + 0], this.vdata[n5 + this.coffset + 1], this.vdata[n5 + this.coffset + 2]);
                vertexCopy.c = vertexCopy.c3;
            } else if (CompressionStream.this.vertexColor4) {
                n5 = n4 * this.vstride;
                vertexCopy.c4 = new Color4f(this.vdata[n5 + this.coffset + 0], this.vdata[n5 + this.coffset + 1], this.vdata[n5 + this.coffset + 2], this.vdata[n5 + this.coffset + 3]);
                vertexCopy.c = vertexCopy.c4;
            }
        }
    }

    private class InterleavedGeometryNIO
    extends InterleavedGeometry {
        FloatBufferWrapper fbw;

        InterleavedGeometryNIO(GeometryArray geometryArray) {
            super(geometryArray);
            this.fbw = null;
            J3DBuffer j3DBuffer = geometryArray.getInterleavedVertexBuffer();
            if (BufferWrapper.getBufferType(j3DBuffer) != 3) {
                throw new IllegalArgumentException("\ninterleaved vertex buffer must be FloatBuffer");
            }
            this.fbw = new FloatBufferWrapper(j3DBuffer);
        }

        void copyVertex(int n2, int n3, int n4, VertexCopy vertexCopy) {
            int n5 = n2 * this.vstride;
            vertexCopy.p = new Point3f(this.fbw.get(n5 + this.poffset + 0), this.fbw.get(n5 + this.poffset + 1), this.fbw.get(n5 + this.poffset + 2));
            if (CompressionStream.this.vertexNormals) {
                n5 = n3 * this.vstride;
                vertexCopy.n = new Vector3f(this.fbw.get(n5 + this.noffset + 0), this.fbw.get(n5 + this.noffset + 1), this.fbw.get(n5 + this.noffset + 2));
            }
            if (CompressionStream.this.vertexColor3) {
                n5 = n4 * this.vstride;
                vertexCopy.c3 = new Color3f(this.fbw.get(n5 + this.coffset + 0), this.fbw.get(n5 + this.coffset + 1), this.fbw.get(n5 + this.coffset + 2));
                vertexCopy.c = vertexCopy.c3;
            } else if (CompressionStream.this.vertexColor4) {
                n5 = n4 * this.vstride;
                vertexCopy.c4 = new Color4f(this.fbw.get(n5 + this.coffset + 0), this.fbw.get(n5 + this.coffset + 1), this.fbw.get(n5 + this.coffset + 2), this.fbw.get(n5 + this.coffset + 3));
                vertexCopy.c = vertexCopy.c4;
            }
        }
    }

    private class MeshReference
    extends CompressionStreamElement {
        int stripFlag;
        int meshIndex;

        MeshReference(int n2, int n3) {
            this.stripFlag = n2;
            this.meshIndex = n3;
            ++CompressionStream.this.meshReferenceCount;
        }

        void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
            CompressionStreamVertex compressionStreamVertex = CompressionStream.this.meshBuffer.getVertex(this.meshIndex);
            CompressionStream.this.lastPosition[0] = compressionStreamVertex.xAbsolute;
            CompressionStream.this.lastPosition[1] = compressionStreamVertex.yAbsolute;
            CompressionStream.this.lastPosition[2] = compressionStreamVertex.zAbsolute;
            if (!(compressionStreamVertex.color == null || CompressionStream.this.lastElementColor || CompressionStream.this.lastElementNormal && CompressionStream.this.lastLastElementColor)) {
                CompressionStream.this.lastColor[0] = compressionStreamVertex.color.rAbsolute;
                CompressionStream.this.lastColor[1] = compressionStreamVertex.color.gAbsolute;
                CompressionStream.this.lastColor[2] = compressionStreamVertex.color.bAbsolute;
                CompressionStream.this.lastColor[3] = compressionStreamVertex.color.aAbsolute;
            }
            if (!(compressionStreamVertex.normal == null || CompressionStream.this.lastElementNormal || CompressionStream.this.lastElementColor && CompressionStream.this.lastLastElementNormal)) {
                CompressionStream.this.lastSextant = compressionStreamVertex.normal.sextant;
                CompressionStream.this.lastOctant = compressionStreamVertex.normal.octant;
                CompressionStream.this.lastU = compressionStreamVertex.normal.uAbsolute;
                CompressionStream.this.lastV = compressionStreamVertex.normal.vAbsolute;
                CompressionStream.this.lastSpecialNormal = compressionStreamVertex.normal.specialNormal;
            }
        }

        void outputCommand(HuffmanTable huffmanTable, CommandStream commandStream) {
            int n2 = 32;
            long l2 = this.stripFlag & 1;
            commandStream.addCommand(n2 |= (this.meshIndex & 0xF) << 1 | this.stripFlag >> 1, 8, l2, 1);
        }

        public String toString() {
            return "meshReference: stripFlag " + this.stripFlag + " meshIndex " + this.meshIndex;
        }
    }

    private class NormalQuant
    extends CompressionStreamElement {
        int value;

        NormalQuant(int n2) {
            this.value = n2;
        }

        void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
            CompressionStream.this.normalQuant = this.value;
            CompressionStream.this.normalQuantChanged = true;
        }

        public String toString() {
            return "normalQuant: " + this.value;
        }
    }

    private class PositionQuant
    extends CompressionStreamElement {
        int value;

        PositionQuant(int n2) {
            this.value = n2;
        }

        void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
            CompressionStream.this.positionQuant = this.value;
            CompressionStream.this.positionQuantChanged = true;
            CompressionStream.this.scale = 2.0 / CompressionStream.this.positionRangeMaximum * ((double)((1 << this.value - 1) - 1) / (double)(1 << this.value - 1));
        }

        public String toString() {
            return "positionQuant: " + this.value;
        }
    }

    private static class VertexCopy {
        Object c = null;
        Point3f p = null;
        Vector3f n = null;
        Color3f c3 = null;
        Color4f c4 = null;

        private VertexCopy() {
        }
    }

    private static class VertexIndices {
        int pi;
        int ni;
        int ci;

        private VertexIndices() {
        }
    }
}

